
function createAssaultArmies()
	LeftAttackRecruit = LazyUnlimitedArmy:New({
		Player = 2,
		Area = 4250,
		AutoDestroyIfEmpty = true,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
		},
		6,NumberOfUAs)
		LeftAttackRecruit.collectpos = GetPosition("assaultleft")
	RightAttackRecruit = LazyUnlimitedArmy:New({
		Player = 2,
		Area = 4250,
		AutoDestroyIfEmpty = true,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
		},
		7,NumberOfUAs)
		RightAttackRecruit.collectpos = GetPosition("assaultright")
	local p2barracks = {Logic.GetPlayerEntities(2, Entities.PB_Barracks2, 5)}
	table.remove(p2barracks,1)
	local p2archers = {Logic.GetPlayerEntities(2, Entities.PB_Archery2, 5)}
	table.remove(p2archers,1)
	local p2stables = {Logic.GetPlayerEntities(2, Entities.PB_Stable2, 5)}
	table.remove(p2stables,1)
	local p2cannons = {Logic.GetPlayerEntities(2, Entities.PB_Foundry2, 5)}
	table.remove(p2cannons,1)
	buildingstable = {}
	for k,v in pairs(p2barracks) do
		table.insert(buildingstable,v)
	end
	for k,v in pairs(p2archers) do
		table.insert(buildingstable,v)
	end
	for k,v in pairs(p2stables) do
		table.insert(buildingstable,v)
	end
	for k,v in pairs(p2cannons) do
		table.insert(buildingstable,v)
	end
	
	secondtable = CopyTable(buildingstable)
	
	LeftAttackerRecuiter = UnlimitedArmyRecruiter:New(LeftAttackRecruit,{
		Buildings = buildingstable,
		ArmySize = 15,
		UCats = {
			{UCat = UpgradeCategories.LeaderSword, SpawnNum = 3, Looped = true},
			{UCat = UpgradeCategories.LeaderBow, SpawnNum = 3, Looped = true},
			{UCat = UpgradeCategories.LeaderHeavyCavalry, SpawnNum = 2, Looped = true},
			{UCat = UpgradeCategories.Cannon3, SpawnNum = 2, Looped = true},
			{UCat = UpgradeCategories.LeaderPoleArm, SpawnNum = 3, Looped = true},
			{UCat = UpgradeCategories.LeaderRifle, SpawnNum = 2, Looped = true}
		},
		ResCheat = true,
		RemoveUnavailable = true
	})
	RightAttackerRecuiter = UnlimitedArmyRecruiter:New(RightAttackRecruit,{
		Buildings = secondtable,
		ArmySize = 14,
		UCats = {
			{UCat = UpgradeCategories.LeaderSword, SpawnNum = 2, Looped = true},
			{UCat = UpgradeCategories.LeaderBow, SpawnNum = 2, Looped = true},
			{UCat = UpgradeCategories.LeaderCavalry, SpawnNum = 2, Looped = true},
			{UCat = UpgradeCategories.Cannon3, SpawnNum = 1, Looped = true},
			{UCat = UpgradeCategories.Cannon4, SpawnNum = 1, Looped = true},
			{UCat = UpgradeCategories.LeaderPoleArm, SpawnNum = 2, Looped = true},
			{UCat = UpgradeCategories.LeaderHeavyCavalry, SpawnNum = 2, Looped = true},
			{UCat = UpgradeCategories.LeaderRifle, SpawnNum = 2, Looped = true}
		},
		ResCheat = true,
		RemoveUnavailable = true
	})
	
	LeftBaseAttack = LazyUnlimitedArmy:New({
		Player = 2,
		Area = 3750,
		AutoDestroyIfEmpty = false,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
		},
		8,NumberOfUAs)
	RightBaseAttack = LazyUnlimitedArmy:New({
		Player = 2,
		Area = 3750,
		AutoDestroyIfEmpty = false,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
		},
		9,NumberOfUAs)
	RightBaseAttack.Bridge = Entities.PB_Bridge1
	RightBaseAttack.MainPos = GetPosition("assaultTwoOccupy")
	RightBaseAttack.DefRange = 15000
	LeftBaseAttack.Bridge = Entities.PB_Bridge2
	LeftBaseAttack.MainPos = GetPosition("briefing1")
	LeftBaseAttack.DefRange = 12000
	
	LeftAttackRecruit.TransferTo = LeftBaseAttack
	LeftAttackRecruit.NextTarget = GetPosition("briefing1")
	RightAttackRecruit.TransferTo = RightBaseAttack
	RightAttackRecruit.NextTarget = GetPosition("assaultTwoOccupy")
	
	LeftAttackRecruit:AddCommandMove(GetPosition("assaultleft"),false)
	LeftAttackRecruit:AddCommandWaitForIdle(false)
	LeftAttackRecruit:AddCommandWaitForSpawnerFull(false)
	LeftAttackRecruit:AddCommandSetSpawnerStatus(false,false)
	
	RightAttackRecruit:AddCommandMove(GetPosition("assaultright"),false)
	RightAttackRecruit:AddCommandWaitForIdle(false)
	RightAttackRecruit:AddCommandWaitForSpawnerFull(false)
	RightAttackRecruit:AddCommandSetSpawnerStatus(false,false)
	
	LeftBaseAttack:AddCommandLuaFunc(HandleAttack,true)
	RightBaseAttack:AddCommandLuaFunc(HandleAttack,true)
	
	--RightBaseAttack:AddCommandDefend(GetPosition("assaultTwoOccupy"),15000,true)
	--LeftBaseAttack:AddCommandDefend(GetPosition("briefing1"),12000,true)
	
	GUIQuestTools.ToggleStopWatch(600,1)
	StartSimpleJob("AttackDelayer")
	StartSimpleJob("CheckBackSide")
end

function CheckBackSide()
	--TODO: Position ermitteln
	local checkpos = GetPosition("TroopsCheck")
	if Logic.IsPlayerEntityOfCategoryInArea(1, checkpos.X, checkpos.Y, 1500, "Leader", "Hero", "Serf", "Cannon","Sword") == 1 then
		if not IsDead("Base") then
			StartCounterThings()
		end
		return true
	end
	return false
end

GameCallback_OnBuildingConstructionCompleteOld=GameCallback_OnBuildingConstructionComplete
function GameCallback_OnBuildingConstructionComplete(_BuildingID,_PlayerID)
	GameCallback_OnBuildingConstructionCompleteOld(_BuildingID,_PlayerID)
	if _PlayerID == 2 then
		local enttype = Logic.GetEntityType(_BuildingID)
		if enttype == Entities.PB_DarkTower1 then
			StartSimpleHiResJob("TowerDelayBuild",enttype,_BuildingID)
		end
	end
end

GameCallback_OnBuildingUpgradeCompleteOld = GameCallback_OnBuildingUpgradeComplete
function GameCallback_OnBuildingUpgradeComplete(_OldID, _NewID)
	GameCallback_OnBuildingUpgradeCompleteOld(_OldID, _NewID)
	if Logic.EntityGetPlayer(_NewID) == 2 then
		local _enttype = Logic.GetEntityType(_NewID)
		if _enttype == Entities.PB_DarkTower2 then
			StartSimpleHiResJob("TowerDelayBuild",_enttype,_NewID)
		end
	end
end

function TowerDelayBuild(_enttype,_BuildingID)
	local upgradecosts = {}
	Logic.FillBuildingUpgradeCostsTable(_enttype, upgradecosts)
	for res,amount in pairs(upgradecosts) do
		Logic.AddToPlayersGlobalResource(2, res, amount)
	end
	GUI.UpgradeSingleBuilding(_BuildingID)
	return true
end

function StartCounterThings()
	local BackTowers = {Logic.GetPlayerEntities(2, Entities.PB_DarkTower2, 4)}
	table.remove(BackTowers,1)
	for i = 1, table.getn(BackTowers), 1 do
		Logic.AddToPlayersGlobalResource(2, ResourceType.Stone, 250)
		Logic.AddToPlayersGlobalResource(2, ResourceType.Sulfur, 250)
		GUI.UpgradeSingleBuilding(BackTowers[i])
	end
	StartSimpleJob("BuildTowerDelayer")
	
	BackAttack = LazyUnlimitedArmy:New({
		Player = 2,
		Area = 3500,
		AutoDestroyIfEmpty = true,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		HiResJob = true
	},10,NumberOfUAs)
	BackAttackSpawner = UnlimitedArmySpawnGenerator:New(BackAttack,{
		Position = GetPosition("backattackspawn"),
		ArmySize = 14,
		SpawnCounter = 300,
		SpawnLeaders = 14,
		LeaderDesc = {
			{LeaderType = Entities.PU_LeaderSword4, SoldierNum = 8, SpawnNum = 3, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderPoleArm4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderBow4, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderHeavyCavalry2, SoldierNum = 3, SpawnNum = 1, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderCavalry2, SoldierNum = 3, SpawnNum = 1, Looped = true, Experience = 3},
			{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 1, Looped = true, Experience = 3},
			{LeaderType = Entities.PU_LeaderRifle1, SoldierNum = 4, SpawnNum = 4, Looped = true, Experience = 3}
		},
		Generator = "Base"
	})
	BackAttack:AddCommandMove(GetPosition("Base"),true)
	BackAttack:AddCommandWaitForSpawnerFull(true)
	BackAttack:AddCommandMove(GetPosition("walkpoint1"),true)
	BackAttack:AddCommandWaitForIdle(true)
	BackAttack:AddCommandMove(GetPosition("TroopsCheck"),true)
	BackAttack:AddCommandWaitForIdle(true)
	BackAttack:AddCommandMove(GetPosition("entrance"),true)
	BackAttack:AddCommandWaitForIdle(true)
	BackAttack:AddCommandMove(GetPosition("atmine"),true)
	BackAttack:AddCommandWaitForIdle(true)
	BackAttack:AddCommandMove(GetPosition("atchurch"),true)
	BackAttack:AddCommandWaitForIdle(true)
	BackAttack:AddCommandMove(GetPosition("player1"),true)
	BackAttack:AddCommandWaitForIdle(true)
end

function BuildTowerDelayer()
	--if Counter.Tick2("ticker",30) then
		local T1 = GetPosition("tower1")
		Logic.CreateConstructionSite(T1.X, T1.Y, 0, Entities.PB_DarkTower1, 2)
		T1 = GetPosition("tower2")
		Logic.CreateConstructionSite(T1.X, T1.Y, 0, Entities.PB_DarkTower1, 2)
		T1 = GetPosition("tower3")
		Logic.CreateConstructionSite(T1.X, T1.Y, 0, Entities.PB_DarkTower1, 2)
		return true
	--end
	--return false
end

function HandleAttack(self)
	if not self:IsIdle() then
		return false
	end
	if self:GetSize(true,false) <= 0 then
		return false, UnlimitedArmy.CreateCommandMove(self.MainPos)
	end
	local bridges = {Logic.GetEntitiesInArea(self.Bridge, self.MainPos.X, self.MainPos.Y, 10000, 1)}
	if bridges[1] then
		return false, UnlimitedArmy.CreateCommandMove(GetPosition("player1"))
	else
		return false, UnlimitedArmy.CreateCommandDefend(self.MainPos,self.DefRange)
	end
end

function AttackDelayer()
	if Counter.Tick2("ArmiesAttack",600) then
		LeftAttackRecruit:AddCommandLuaFunc(MoveAndTransfer,true)
		RightAttackRecruit:AddCommandLuaFunc(MoveAndTransfer,true)
		
		--LeftAttackRecruit:AddCommandMove(GetPosition("assaultleft"),true)
		LeftAttackRecruit:AddCommandMove(LeftAttackRecruit.collectpos,true) 
		LeftAttackRecruit:AddCommandWaitForIdle(true)
		LeftAttackRecruit:AddCommandWaitForSpawnerFull(true)
		LeftAttackRecruit:AddCommandSetSpawnerStatus(false,true)
	
		--RightAttackRecruit:AddCommandMove(GetPosition("assaultright"),true)
		RightAttackRecruit:AddCommandMove(RightAttackRecruit.collectpos,true) 
		RightAttackRecruit:AddCommandWaitForIdle(true)
		RightAttackRecruit:AddCommandWaitForSpawnerFull(true)
		RightAttackRecruit:AddCommandSetSpawnerStatus(false,true)
		
		return true
	end
	return false
end

function MoveAndTransfer(self)
	if self.TransferTo:GetSize(true,false) <= 3 and self:GetSize(true,false) <= 0 then
		return true, UnlimitedArmy.CreateCommandSetSpawnerStatus(true)
		--return true, UnlimitedArmy.CreateCommandMove(self.collectpos) 
	end
	if self.Status == UnlimitedArmy.Status.Battle or (GetDistance(self:GetPosition(), "player1")<= 15000) then
		for id in self:Iterator(true) do
			Logic.SetSpeedFactor(id, 1)
			self:RemoveLeader(id)
			self.TransferTo:AddLeader(id)
		end
		return false
	end
	if not self:IsIdle() then
		return false
	end
	return false, UnlimitedArmy.CreateCommandMove(self.NextTarget)
end